jQuery(document).ready(function () {
    jQuery(document).on("click", "#siteseo-seo-tab", function (e) {
        jQuery("#elementor-panel-footer-settings").trigger("click");
        jQuery(".elementor-control-siteseo_title_settings").trigger("click");
    });
});

var scriptInitialized = false;
var socialInitialized = false;

const runGooglePreview = function () {
    setTimeout(function () {
        googlePreview();
    }, 1000);
};

var socialPreviewItemView = elementor.modules.controls.BaseData.extend({
    onReady: function () {
        if (
            siteseoFiltersElementor.resize_panel &&
            siteseoFiltersElementor.resize_panel === "1"
        ) {
            elementor.panel.storage.size.width = "495px";
            elementor.panel.setSize();
        }

        var $ = jQuery;

        const observeFBThumbnail = function () {
            let fbThumbnail = document.querySelectorAll(
                ".elementor-control-_siteseo_social_fb_img .elementor-control-media__preview"
            );

            if (!fbThumbnail.length) {
                return;
            }

            fbThumbnail = fbThumbnail[0];

            const observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    if (
                        mutation.type == "attributes" &&
                        mutation.attributeName == "style"
                    ) {
                        let img = mutation.target.style.backgroundImage
                            .replace('url("', "")
                            .replace('")', "");
                        if (!img.length) {
                            img = elSocialData.fbDefaultImage;
                        }
                        $(".snippet-fb-img img").attr("src", img);
                        siteseo_social_img("fb");
                    }
                });
            });

            observer.observe(fbThumbnail, {
                attributes: true,
            });
        };

        const observeTWThumbnail = function () {
            let twThumbnail = document.querySelectorAll(
                ".elementor-control-_siteseo_social_twitter_img .elementor-control-media__preview"
            );

            if (!twThumbnail.length) {
                return;
            }

            twThumbnail = twThumbnail[0];

            const observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    if (
                        mutation.type == "attributes" &&
                        mutation.attributeName == "style"
                    ) {
                        let img = mutation.target.style.backgroundImage
                            .replace('url("', "")
                            .replace('")', "");
                        if (!img.length) {
                            img = elSocialData.twDefaultImage;
                        }
                        $(".snippet-twitter-img-default img").attr("src", img);
                        siteseo_social_img("twitter");
                    }
                });
            });

            observer.observe(twThumbnail, {
                attributes: true,
            });
        };

        const updateFbSnippetTitle = function () {
            let value = $(this).val();

            if (value == "") {
                value = $(this).attr("placeholder");
            }

            $(".snippet-fb-title").html(value);
        };

        const updateFbSnippetDesc = function () {
            let value = $(this).val();

            if (value == "") {
                value = $(this).attr("placeholder");
            }

            $(".snippet-fb-description-custom").html(value);
        };

        const updateTwSnippetTitle = function () {
            let value = $(this).val();

            if (value == "") {
                value = $(this).attr("placeholder");
            }

            $(".snippet-twitter-title").html(value);
        };

        const updateTwSnippetDesc = function () {
            let value = $(this).val();

            if (value == "") {
                value = $(this).attr("placeholder");
            }

            $(".snippet-twitter-description").html(value);
        };

        $(document).on(
            "input",
            "input[data-setting=_siteseo_social_fb_title]",
            updateFbSnippetTitle
        );
        $(document).on(
            "input",
            "textarea[data-setting=_siteseo_social_fb_desc]",
            updateFbSnippetDesc
        );

        $(document).on(
            "input",
            "input[data-setting=_siteseo_social_twitter_title]",
            updateTwSnippetTitle
        );
        $(document).on(
            "input",
            "textarea[data-setting=_siteseo_social_twitter_desc]",
            updateTwSnippetDesc
        );

        if (!scriptInitialized) {
            if ($("#toggle-preview").attr("data-toggle") == "1") {
                $(
                    ".elementor-control-field.google-snippet-box .google-snippet-preview"
                ).addClass("mobile-preview");
            } else {
                $(
                    ".elementor-control-field.google-snippet-box .google-snippet-preview"
                ).removeClass("mobile-preview");
            }

            $(document).on(
                "click",
                ".elementor-control-field.google-snippet-box #toggle-preview",
                function () {
                    $(
                        ".elementor-control-field.google-snippet-box #toggle-preview"
                    ).attr(
                        "data-toggle",
                        $(
                            ".elementor-control-field.google-snippet-box #toggle-preview"
                        ).attr("data-toggle") == "1"
                            ? "0"
                            : "1"
                    );
                    $(
                        ".elementor-control-field.google-snippet-box .google-snippet-preview"
                    ).toggleClass("mobile-preview");
                }
            );

            scriptInitialized = true;
        }

        $(document).on(
            "click",
            "#elementor-panel-saver-button-publish-label",
            runGooglePreview
        );

        setTimeout(function () {
            observeFBThumbnail();
            observeTWThumbnail();
        }, 1000);

        if (this.model.get("network") !== "google" && !socialInitialized) {
            socialInitialized = true;
            socialPreview();
        }

        if (this.model.get("network") === "google") {
            googlePreview();
        } else if (this.model.get("network") === "facebook") {
            setTimeout(function () {
                siteseo_social_img("fb");
            }, 1000);
        } else {
            setTimeout(function () {
                siteseo_social_img("twitter");
            }, 1000);
        }
    },

    onBeforeDestroy() {
        jQuery(document).off(
            "click",
            "#elementor-panel-saver-button-publish-label",
            runGooglePreview
        );
    },
});

elementor.addControlView("siteseo-social-preview", socialPreviewItemView);
